
import { SlotplanHourWidget } from '../../slot/slotplan/SlotplanHourWidget.js';
import { SlotplanDayWidget } from './SlotplanDayWidget.js';


export class RentalSlotOccupationWidget {
	
	tplHour = `
		<div class="rental-slot-occupation-widget">
			<ez-date name="startDate"
						label="Week date"
						[value]="startDate"
						[onchange]="widget.startDate_Change"></ez-date>
		</div>
		
		<div class="rental-slot-container"></div>
	`;
	
	tplDay = `
		<div class="rental-slot-occupation-widget">
			<ez-date name="startDate"
						label="Week date"
						[value]="startDate"
						[onchange]="widget.startDate_Change"></ez-date>
		</div>
	
		<div class="rental-slot-container"></div>
	`;
	
	tplWeek = `
	`;
	
	tplMonth = `
		
	`;
	
	
	container = null;
	article = null;
	slotplan = null;
	slotplanType = null;

	startDate = null;

	lines = [];

	callbackDateSelected = null;
	
	slotplanHourWidget = null;
	slotplanDayWidget = null;
	slotplanWeekWidget = null;
	slotplanMonthWidget = null;
	
	


	constructor( ) {
		
	}

	setArticle( article ) { this.article = article; }
	setStartDate( m ) {
		this.startDate = m;
	}
	
	
	async init(e) {
		this.container = e;
		
		await this.loadOccupation();
		
		this.render();
	}
	
	startDate_Change(evt) {
//		console.log('jow');
		let d = evt.target.value;
		if (valid_date(d)) {
			this.startDate = format_date(d);
			this.render();
		}
	}

	async loadOccupation() {
//		console.log( this.article );
		
		// get slotplan info
		let r1 = await postJson('/service/sales/rental/articleSearch.do', {
			a: 'slotplanView',
			slotplanId: this.article.slotplanId
		});
		let json1 = await r1.json();
		this.slotplan = json1.slotplan;
		this.slotplanType = json1.slotplan.defaultSlotType;
		
		
		let sd = null;
		let ed = null;
		if (this.slotplanType == 'hour') {
			sd = start_of_week( this.startDate );
			ed = end_of_week( this.startDate );
		}
		if (this.slotplanType == 'day') {
			sd = start_of_month( this.startDate );
			ed = end_of_month( next_month(this.startDate, 2) );
		}
		if (this.slotplanType == 'week' || this.slotplanType == 'month') {
			sd = start_of_year( this.startDate );
			ed = end_of_year( this.startDate );
			
		}
		
		let r2 = await postJson('/service/sales/rental/rental.do', {
			a: 'occupationByPeriod',
			articleId: this.article.articleId,
			startDate: sd,
			endDate: ed
		});
		
		let json2 = await r2.json();
		
		this.lines = json2.lines;
	}
	
	
	renderHour() {
		$(this.container).empty();
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tplHour );
		eztpl.setObject('widget', this);
		eztpl.setVar('startDate', format_date(this.startDate));
		eztpl.render();
		
		
		this.slotplanHourWidget = new SlotplanHourWidget( this.slotplan );
		this.slotplanHourWidget.setArticle( this.article );
		this.slotplanHourWidget.setEditMode( false );
		this.slotplanHourWidget.setDate( this.startDate );
		this.slotplanHourWidget.init('.rental-slot-container')
		
		this.slotplanHourWidget.render();
	}
	
	renderDay() {
		$(this.container).empty();

		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tplDay );
		eztpl.setObject('widget', this);
		eztpl.setVar('startDate', format_date(this.startDate));
		eztpl.render();


		this.slotplanDayWidget = new SlotplanDayWidget( this.slotplan );
		this.slotplanDayWidget.setDate( this.startDate );
		this.slotplanDayWidget.init('.rental-slot-container')

		this.slotplanDayWidget.render();
		
	}
	
	renderWeek() {
		
	}
	
	renderMonth() {
		
	}
	
	
	getRentalLines() {
		if (this.slotplanType == 'hour') {
			let dates = this.slotplanHourWidget.getSelectedSlots();
			
			let lines = [];
			for(let i in dates) {
				let l = Object.assign({}, this.article);
				l.startDate = dates[i].start;
				l.endDate = dates[i].end;
				
				if (!l.originalDescription)
					l.originalDescription = l.shortDescription;
				
				l.shortDescription += ' - ' + _('daynoshort.'+l.startDate.getDay()) + ' ' + format_date(l.startDate, {dmy: true}) + ' ' + format_time(l.startDate) + " t/m " + format_time(l.endDate);
				
				l.priceExclVat = dates[i].priceExclVat;
				l.priceInclVat = dates[i].priceInclVat;
				
				lines.push(l);
			}
			return lines;
		}
		
		if (this.slotplanType == 'day') {
			console.log('hit?');
			let dates = this.slotplanDayWidget.getSelectedSlots();
			
			let lines = [];
			for(let i in dates) {
				let l = Object.assign({}, this.article);
				l.startDate = dates[i].start;
				l.endDate = dates[i].end;
				
				if (!l.originalDescription)
					l.originalDescription = l.shortDescription;
				
				l.shortDescription += ' - ' + _('daynoshort.'+l.startDate.getDay()) + ' ' + format_date(l.startDate, {dmy: true});
				
				lines.push(l);
			}
			return lines;
		}
		
		return [];
	}
	
	
	
	render() {
		if (this.slotplanType == 'hour') {
			this.renderHour();
		}
		if (this.slotplanType == 'day') {
			this.renderDay();
		}
		if (this.slotplanType == 'week') {
			this.renderWeek();
		}
		if (this.slotplanType == 'month') {
			this.renderMonth();
		}
		
	}

	
}

